//package globalExamples;

import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.FundamentalMetadataObject;

import oracle.olapi.metadata.mdm.MdmCustomObjectFactory;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

import oracle.olapi.metadata.mtm.MtmCustomObjectFactory;
import oracle.olapi.metadata.mtm.MtmValueExpression;

/**
 * This program creates the custom MdmAttribute for product colors and produces
 * the results that appear in table in the Elements of an MdmAttribute section
 * of Chapter 2, Understanding OLAP API Metadata, in the Oracle OLAP
 * Developer's Guide to the OLAP API.
 *
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 *
 * @author Oracle Corporation
 */
public class ElementsOfMdmAttribute
{
  public ElementsOfMdmAttribute()
  {
  }

  public void run(String [] args)
  {
    Context10g context = new Context10g(args, false);
    DataProvider dp = context.getDataProvider();


    // Get the MdmPrimaryDimension for the Global schema dimension of product
    // values.
    MdmPrimaryDimension mdmProdDim =
                             context.getMdmPrimaryDimensionByName("PRODUCT");

    context.println("\nCreating a custom MdmAttribute of product colors, " +
                    "\njoining it to the short description attribute and " +
                    "\nto the dimension, and displaying the result.");

    // Get the default hierarchy for the PRODUCT dimension.
    MdmLevelHierarchy mdmProdHier = (MdmLevelHierarchy)
                                     mdmProdDim.getDefaultHierarchy();

    // Get the Source for the hierarchy.
    Source prodHier = mdmProdHier.getSource();

    // Get the short value description attribute for the primary dimension.
    MdmAttribute mdmProdShortDescr =
                               mdmProdDim.getShortValueDescriptionAttribute();
    Source prodShortDescr = mdmProdShortDescr.getSource();

    // Get the FundamentalMetadataProvider and the String data type object.
    FundamentalMetadataProvider fdp =
                                   context.dp.getFundamentalMetadataProvider();
    FundamentalMetadataObject fmoSstringDT = fdp.getStringDataType();

    // Create a String for a SQL expression that assigns color values to
    // products.
    String sqlExp = "(case when item_id in " +
                    "(13, 14, 15, 19, 22, 24, 27, 33, 34, 35, 46, 48) " +
                    "then 'Black' " +
                    "when item_id in (16, 17, 18, 20, 21, 23, 32, 36, 37, 47)" +
                    " then 'Beige' " +
                    "when item_id in (25, 26, 30, 31) then 'Green' " +
                    "when item_id in (28) then 'Red' " +
                    "when item_id in (29) then 'Orange' " +
                    "when item_id in (40, 41, 42, 43, 44, 45) then 'Blue' " +
                    "else null end)";

    // Get the MtmCustomObjectFactory and create a custom expression with the
    // SQL statement.
    MtmCustomObjectFactory mtmCustObjFactory =
                                       context.mp.getMtmCustomObjectFactory();
    MtmValueExpression expression = (MtmValueExpression)
       mtmCustObjFactory.createCustomExpression(sqlExp, fmoSstringDT);

    // Get the MdmCustomObjectFactory and create a custom attribute with the
    // custom expression.
    MdmCustomObjectFactory mdmCustObjFactory =
                                        context.mp.getMdmCustomObjectFactory();
    MdmAttribute mdmProdColorAttr =
          mdmCustObjFactory.createStringAttribute("ProductColor",
                                                   mdmProdDim,
                                                   expression);
    // Get the Source for the custom attribute.
    Source prodColorAttr = mdmProdColorAttr.getSource();

    // Produce a Source that has a short description for each product.
    Source prodByShortDescr = prodShortDescr.join(prodHier);

    //Produce a Source that has the color of each product.
    Source prodByColor = prodColorAttr.join(prodByShortDescr);

    // Prepare and commit the current Transaction, create a Cursor for the
    // Source, and display the values of the Cursor.
    context.commit();
    context.displayResult(prodByColor);
  }

  public static void main(String[] args)
  {
    new ElementsOfMdmAttribute().run(args);
  }
}
